/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.json;

import com.aptana.core.util.SourcePrinter;
import com.aptana.json.IPropertyContainer;
import com.aptana.json.ISchemaContext;
import com.aptana.json.IState;
import com.aptana.json.Messages;
import com.aptana.json.Schema;
import com.aptana.json.SchemaEventType;
import com.aptana.json.SchemaPrimitive;
import com.aptana.json.SchemaProperty;
import java.util.HashMap;
import java.util.Map;

public class SchemaObject
implements IState,
IPropertyContainer {
    private Schema _owningSchema;
    private Map<String, SchemaProperty> _properties;
    private String _description;
    private ObjectState _currentState;
    private String _currentPropertyName;
    private IState _currentPropertyType;
    private String _currentPropertyTypeName;

    public SchemaObject(Schema owningSchema) {
        this._owningSchema = owningSchema;
    }

    public void addProperty(SchemaProperty property) {
        if (this._properties == null) {
            this._properties = new HashMap<String, SchemaProperty>();
        }
        this._properties.put(property.getName(), property);
    }

    public SchemaProperty addProperty(String name, String typeName) {
        SchemaProperty result = this._owningSchema.createProperty(name, typeName);
        this.addProperty(result);
        return result;
    }

    public void enter() {
        this._currentState = ObjectState.READY;
    }

    public void exit() {
    }

    public String getDescription() {
        return this._description;
    }

    public Schema getOwningSchema() {
        return this._owningSchema;
    }

    public SchemaProperty getProperty(String name) {
        SchemaProperty result = null;
        if (this._properties != null) {
            result = this._properties.get(name);
        }
        return result;
    }

    public String getTypeName() {
        return this._currentPropertyTypeName;
    }

    public boolean hasProperty(String name) {
        return this._properties != null && this._properties.containsKey(name);
    }

    public boolean isValidTransition(SchemaEventType event, Object value) {
        boolean result = false;
        switch (event) {
            case START_OBJECT: {
                result = this._currentState == ObjectState.READY;
                break;
            }
            case START_OBJECT_ENTRY: {
                result = this._currentState == ObjectState.IN_OBJECT && value != null && value.toString().length() > 0;
                break;
            }
            case END_OBJECT: {
                result = this._currentState == ObjectState.IN_OBJECT;
                break;
            }
            case END_OBJECT_ENTRY: {
                result = this._currentState == ObjectState.IN_PROPERTY;
            }
        }
        return result;
    }

    public void setDescription(String description) {
        this._description = description;
    }

    public void setProperty(String propertyName, String propertyTypeName, Object value) {
        SchemaProperty property = this.addProperty(propertyName, propertyTypeName);
        property.setValue(value);
    }

    public String toSource() {
        SourcePrinter writer = new SourcePrinter();
        this.toSource(writer);
        return writer.toString();
    }

    public void toSource(SourcePrinter writer) {
        if (this._properties != null && !this._properties.isEmpty()) {
            for (Map.Entry<String, SchemaProperty> entry : this._properties.entrySet()) {
                SchemaProperty property = entry.getValue();
                property.toSource(writer);
            }
        }
    }

    public void transition(ISchemaContext context, SchemaEventType event, Object value) {
        switch (event) {
            case START_OBJECT: {
                if (this._currentState != ObjectState.READY) {
                    throw new IllegalStateException(Messages.SchemaObject_Cannot_Start_Started_Object);
                }
                this._currentState = ObjectState.IN_OBJECT;
                break;
            }
            case START_OBJECT_ENTRY: {
                if (this._currentState != ObjectState.IN_OBJECT) {
                    throw new IllegalStateException(Messages.SchemaObject_Cannot_Start_Started_Object_Entry);
                }
                if (value == null || value.toString().length() == 0) {
                    throw new IllegalStateException(Messages.SchemaObject_Property_Must_Have_Name);
                }
                String name = value.toString();
                SchemaProperty property = this.getProperty(name);
                this._currentState = ObjectState.IN_PROPERTY;
                this._currentPropertyName = name;
                if (property == null) {
                    this._currentPropertyType = new Schema();
                    this._currentPropertyTypeName = this._owningSchema.getRootTypeName();
                } else {
                    this._currentPropertyType = property.getType();
                    this._currentPropertyTypeName = property.getTypeName();
                }
                context.pushType(this._currentPropertyName, this._currentPropertyType);
                if (this._currentPropertyType instanceof SchemaPrimitive) break;
                context.createType(this._currentPropertyTypeName, this._currentPropertyType, value);
                break;
            }
            case END_OBJECT: {
                if (this._currentState != ObjectState.IN_OBJECT) {
                    throw new IllegalStateException(Messages.SchemaObject_Cannot_End_Unstarted_Object);
                }
                this._currentState = ObjectState.COMPLETE;
                context.popType();
                break;
            }
            case END_OBJECT_ENTRY: {
                if (this._currentState != ObjectState.IN_PROPERTY) {
                    throw new IllegalStateException(Messages.SchemaObject_Cannot_End_Unstarted_Object_Entry);
                }
                context.setProperty(this._currentPropertyName, this._currentPropertyTypeName, this._currentPropertyType);
                this._currentState = ObjectState.IN_OBJECT;
                this._currentPropertyName = null;
                this._currentPropertyType = null;
                break;
            }
            default: {
                throw new IllegalStateException(String.valueOf(Messages.SchemaObject_Unsupported_Event) + event.name());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ObjectState {
        READY,
        IN_OBJECT,
        IN_PROPERTY,
        COMPLETE;

    }
}

